/**
 * Contain the logic for the add random question modal.
 *
 * @module     mod_quiz/modal_add_random_question
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_quiz/modal_add_random_question",["jquery","core/notification","core/modal","core/modal_events","core/modal_registry","core/fragment","core/templates","core_form/changechecker"],(function($,Notification,Modal,ModalEvents,ModalRegistry,Fragment,Templates,FormChangeChecker){var registered=!1,SELECTORS_EXISTING_CATEGORY_CONTAINER='[data-region="existing-category-container"]',SELECTORS_EXISTING_CATEGORY_FORM_ELEMENT="#id_existingcategoryheader",SELECTORS_NEW_CATEGORY_CONTAINER='[data-region="new-category-container"]',SELECTORS_NEW_CATEGORY_FORM_ELEMENT="#id_newcategoryheader",SELECTORS_TAB_CONTENT='[data-region="tab-content"]',SELECTORS_ADD_ON_PAGE_FORM_ELEMENT='[name="addonpage"]',SELECTORS_SUBMIT_BUTTON_ELEMENT='input[type="submit"]',SELECTORS_CANCEL_BUTTON_ELEMENT='input[type="submit"][name="cancel"]',SELECTORS_FORM_HEADER="legend",SELECTORS_BUTTON_CONTAINER=".fitem",ModalAddRandomQuestion=function(root){Modal.call(this,root),this.contextId=null,this.addOnPageId=null,this.category=null,this.returnUrl=null,this.cmid=null,this.loadedForm=!1};return ModalAddRandomQuestion.TYPE="mod_quiz-quiz-add-random-question",(ModalAddRandomQuestion.prototype=Object.create(Modal.prototype)).constructor=ModalAddRandomQuestion,ModalAddRandomQuestion.prototype.setContextId=function(id){this.contextId=id},ModalAddRandomQuestion.prototype.getContextId=function(){return this.contextId},ModalAddRandomQuestion.prototype.setAddOnPageId=function(id){this.addOnPageId=id,this.getBody().find(SELECTORS_ADD_ON_PAGE_FORM_ELEMENT).val(id)},ModalAddRandomQuestion.prototype.getAddOnPageId=function(){return this.addOnPageId},ModalAddRandomQuestion.prototype.setCategory=function(category){this.category=category},ModalAddRandomQuestion.prototype.getCategory=function(){return this.category},ModalAddRandomQuestion.prototype.setReturnUrl=function(url){this.returnUrl=url},ModalAddRandomQuestion.prototype.getReturnUrl=function(){return this.returnUrl},ModalAddRandomQuestion.prototype.setCMID=function(id){this.cmid=id},ModalAddRandomQuestion.prototype.getCMID=function(){return this.cmid},ModalAddRandomQuestion.prototype.moveFormElementIntoTab=function(formElement,tabElement){var submitButtons=formElement.find(SELECTORS_SUBMIT_BUTTON_ELEMENT),footer=$('<div class="modal-footer mt-1" data-region="footer"></div>');formElement.find(SELECTORS_FORM_HEADER).addClass("hidden"),formElement.wrap(tabElement),submitButtons.closest(SELECTORS_BUTTON_CONTAINER).remove(),submitButtons.appendTo(footer),footer.appendTo(formElement)},ModalAddRandomQuestion.prototype.moveTabsIntoTabContent=function(form){var tabContent=this.getBody().find(SELECTORS_TAB_CONTENT).empty();form.find('[role="tabpanel"]').wrapAll(tabContent)},ModalAddRandomQuestion.prototype.moveCancelButtonToTabs=function(form){var cancelButton=form.find(SELECTORS_CANCEL_BUTTON_ELEMENT).addClass("ml-1"),tabFooters=form.find('[data-region="footer"]');cancelButton.closest(SELECTORS_BUTTON_CONTAINER).remove(),cancelButton.clone().appendTo(tabFooters)},ModalAddRandomQuestion.prototype.loadForm=function(){return Fragment.loadFragment("mod_quiz","add_random_question_form",this.getContextId(),{addonpage:this.getAddOnPageId(),cat:this.getCategory(),returnurl:this.getReturnUrl(),cmid:this.getCMID()}).then(function(html,js){var form=$(html),existingCategoryFormElement=form.find(SELECTORS_EXISTING_CATEGORY_FORM_ELEMENT),existingCategoryTab=this.getBody().find(SELECTORS_EXISTING_CATEGORY_CONTAINER),newCategoryFormElement=form.find(SELECTORS_NEW_CATEGORY_FORM_ELEMENT),newCategoryTab=this.getBody().find(SELECTORS_NEW_CATEGORY_CONTAINER);this.moveFormElementIntoTab(existingCategoryFormElement,existingCategoryTab),this.moveFormElementIntoTab(newCategoryFormElement,newCategoryTab),this.moveTabsIntoTabContent(form),this.moveCancelButtonToTabs(form),Templates.replaceNode(this.getBody().find(SELECTORS_TAB_CONTENT),form,js)}.bind(this)).then((function(){FormChangeChecker.disableAllChecks()})).fail(Notification.exception)},ModalAddRandomQuestion.prototype.show=function(){Modal.prototype.show.call(this),this.loadedForm||(this.loadForm(),this.loadedForm=!0)},registered||(ModalRegistry.register(ModalAddRandomQuestion.TYPE,ModalAddRandomQuestion,"mod_quiz/modal_add_random_question"),registered=!0),ModalAddRandomQuestion}));

//# sourceMappingURL=modal_add_random_question.min.js.map